## Autenticazione ADFS in applicazione Angular 2

### src/app/App.Module.ts
<pre>
import { Http, HttpModule, Response, Headers, RequestOptions } from '@angular/http';
import { AdfsComponent } from 'com-ff3d-adfs';

declarations: [ 
  ...
  AdfsComponent
]
imports: [
  ...
  HttpModule
],
</pre>

### src/environments/environment.ts
<pre>
export const environment = {
  ...
  portalUrl: 'http://localhost:4200',  // Url del portale
  ADFSUrl: 'http://127.0.0.1/ff3dMVCAdfs/home/index/', // Url del MVC su cui fare autenticazione adfs
  logoutADFSUrl: 'https://mpf.manutencoop.it/adfs/ls/?wa=wsignout1.0' // Url per logout
};
</pre>

### src/app/app.component.html
<pre>&lt;app-adfs&gt;&lt;/app-adfs&gt;</pre>

### tsconfig.json
<pre>
"include": [
  "src/**/*"
],
"files": [
  "node_modules/com-ff3d-adfs/index.ts"
]
</pre>
