import { Component } from '@angular/core';
import { environment } from 'environments/environment';
import { Http, HttpModule, Response, Headers, RequestOptions } from '@angular/http';

@Component({
  selector: 'app-adfs',
  templateUrl: './adfs.component.html',
  styleUrls: ['./adfs.component.css']
})
export class AdfsComponent {
  errorPage = false;
  errorMessage = '';
  logoutUrl: string = environment.logoutADFSUrl;

  constructor(private http: Http) {
    const url = new URL(window.location.href);
    const callback = btoa(environment.portalUrl);

    if (url.searchParams.get('user') == null || url.searchParams.get('timespan') == null || url.searchParams.get('bearer') == null) {
      // Vai ad autenticazione ADFS
      console.log('Vai ad autenticazione ADFS');
      window.location.href = environment.ADFSUrl + callback;

    } else {

      if (url.searchParams.get('error') == null) {
        console.log('bearer ' + url.searchParams.get('bearer'));
        localStorage.setItem('token', 'bearer ' + url.searchParams.get('bearer'));
      } else {
        localStorage.clear();
        this.errorMessage = url.searchParams.get('error');
        this.errorPage = true;
      }

    }
  }

}
